freq.true <- c(1,12,26,52,104,156,208,365) #consumptions/year
n.consumers <- 20
m<-length( freq.true )

found.it <- numeric( n.consumers )
estimate <- numeric( m )

get.estimate <- function(){
  for( k in 1:m ){
    for( j in 1:n.consumers ){
      days <- sample( 1:365, freq.true[k] )
      two.day.recall <- sample( 1:364, 1 )
      found.it[j] <- (two.day.recall %in% days)+((two.day.recall+1) %in% days)
    }
    estimate[k] <- 365*mean( found.it)/2
  }
  return( estimate)
}

estimates <- matrix( nrow=100,ncol=m )
for( j in 1:100 ){
    estimates[j,] <- get.estimate()
} 

est.q <- apply( estimates, MARGIN=2, FUN = function(x) quantile(x, c(0.025, 0.975)) )
est.mean = colMeans( estimates )
rbind( freq.true, est.mean, est.q )
