# Likelihood function for answer type 2
loglikbeta <- function( param, f )
{
  a <- exp(param[1])
  b <- exp(param[2])
  n <- nrow( f )
  l <- 0
  for( j in 1:n ) {
    l <- l - f[j,"Freq"] * log( pbeta( f[j,"HIGH"], a, b ) - pbeta(f[j,"LOW"],a,b) ) 
  }
  return( l )
}

# Likelihood for answer type 3
loglikgamma <- function( param, f)
{
  # there are five options here
  # - only low
  # - only high
  # - low and high
  # - value
  # - none
  
  shape <- exp(param[1])
  scale <- exp(param[2])
  
  l <-0
  n <- nrow( f )
  
  for( j in 1:n ) {
    # Only low
    if( !is.na(f[j,"LOW"]) && is.na(f[j,"HIGH"]) ){
      l <- l - f[j,"Freq"] * pgamma( f[j,"LOW"], shape=shape, scale=scale, log.p=TRUE, lower.tail=FALSE )
      next
    }
    
    # Only high
    if( is.na(f[j,"LOW"]) && !is.na(f[j,"HIGH"]) ){
      l <- l - f[j,"Freq"] * pgamma( f[j,"HIGH"], shape=shape, scale=scale, log.p=TRUE )
      next
    }
    
    # Low and high
    if( !is.na(f[j,"LOW"]) && !is.na(f[j,"HIGH"]) ){
      l <- l - f[j,"Freq"] * log( pgamma( f[j,"HIGH"], shape=shape, scale=scale ) -
                                    pgamma( f[j,"LOW"], shape=shape, scale=scale ) )
      next
    }
    if( !is.na(f[j,"VALUE"]) ){
      l <- l - f[j,"Freq"] * dgamma( f[j,"VALUE"], shape=shape, scale=scale, log=TRUE )
      next
    } 
  }
  return( l )
}

# Likelihood for answer type 4
loglikexp <- function( param, data)
{
  # there are five options here
  # - only low
  # - only high
  # - low and high
  # - value
  # - none
  
  l <-0
  n <- nrow( data )
  
  for( j in 1:n ) {
    # Only low
    if( !is.na(data[j,"LOW"]) && is.na(data[j,"HIGH"]) ){
      l <- l - data[j,"Freq"] * pexp( data[j,"LOW"], rate=param,
                                      log.p=TRUE, lower.tail=FALSE )
      next
    }
    
    # Only high
    if( is.na(data[j,"LOW"]) && !is.na(data[j,"HIGH"]) ){
      l <- l - data[j,"Freq"] * pexp( data[j,"HIGH"], rate=param,
                                      log.p=TRUE )
      next
    }
    
    # Low and high
    if( !is.na(data[j,"LOW"]) && !is.na(data[j,"HIGH"]) ){
      l <- l - data[j,"Freq"] * log( pexp( data[j,"HIGH"], rate=param ) -
                                       pexp( data[j,"LOW"], rate=param  ) )
      next
    }
    
    if( !is.na(data[j,"VALUE"]) ){
      l <- l - data[j,"Freq"] * dexp( data[j,"VALUE"], rate=param, log=TRUE )
      next
    } 
  }
  return( l )
}