cat2 <- function( answers, answers.value, weights, label.answer, nMCsamples,
                  savePDF=FALSE, saveExcel=FALSE ){  
  
  n         <- length( answers )
  
  mc.sample <- matrix( 0, nrow=nMCsamples, ncol=nMCsamples,
                       dimnames=list( bootstrap.sample=1:nMCsamples,
                                      sample=1:nMCsamples)
                       )
  ab.hat    <- matrix( 0, nrow=nMCsamples, ncol=2, 
                       dimnames=list( bootstrap.sample=1:nMCsamples,
                                      parameters=c("a", "b")) 
                       )
  
  for( i in 1:nMCsamples )
  {
    # Count occurrences
    ind <-sample.int( n=n, replace=TRUE )
    data.counts <- data.frame( answers = answers[ind], w= 1/weights[ind] ) %>%
                    group_by(answers) %>% summarize( Freq=sum( w) ) 
    # Replace in the data, the answer strings with the numerical values
    data.counts <- merge( data.counts, answers.value, by.x="answers", by.y="ANSWER" )

    param <- c( log(1), log(2) )
    sol<-optim( par=param, fn=loglikbeta, f=data.counts )
    ab.hat[i,] <- exp( sol$par )
    
    mc.sample[i,] <- rbeta( nMCsamples, ab.hat[i,1], ab.hat[i,2] )
  }
  
  stats   <- get.stats.2d( mc.sample )
  
  if( saveExcel ){
    wb <- createWorkbook()
    
    addWorksheet(wb = wb, sheetName = "Param Samples")
    writeData(wb = wb, sheet = "Param Samples", x = ab.hat, borders = "n", rowNames=T)
    addWorksheet(wb = wb, sheetName = "Outcome Statistics")
    writeData(wb = wb, sheet = "Outcome Statistics", x = stats, borders = "n", rowNames=T)
    addWorksheet(wb = wb, sheetName ="Outcome Samples")
    writeData(wb = wb, sheet ="Outcome Samples", x = mc.sample, borders = "n", rowNames=T)
    
    saveWorkbook(wb, paste("./Outcomes/",codes[j], ".xlsx", sep="" ), overwrite = TRUE)
  }
  
  if( savePDF ){
    data.counts$Freq <- data.counts$Freq/n
    p <- ggplot( data.counts, aes( x=VALUE, y=Freq ))
    for( i in 1:nMCsamples )
    {
      p <- p + stat_function(fun = pbeta, geom = "line",# alpha=0.2,
                             args=list(shape1=ab.hat[i,1], shape2=ab.hat[i,2], lower.tail=FALSE ))
    }
    p <- p + scale_y_continuous(labels = percent, breaks=seq(0,1,0.1))
    p <- p + scale_x_continuous( labels = percent_format() )
    p <- p + labs( title = figure.label, x="More than [percentage]", y="Population fraction" )
    p <- p + theme(plot.title = element_text(size = rel(0.5)))
    p + theme_bw()
    ggsave( paste(codes[j], "_stats.eps", sep="" ), path="Figuren", colormodel="RGB",
            width=10, height=10, units="cm" )
  }
  
  return( list( stats=stats, ab.hat=colMeans( ab.hat) ) )
}