
#
# algorithm taken from http://tdunning.blogspot.nl/2010/04/sampling-dirichlet-distributions_06.html
#
rdirichlet = function(n, alpha) {
  k = length(alpha)
  r = matrix(0, nrow=n, ncol=k) 
  for (i in 1:k) {
    r[,i] = rgamma(n, alpha[i], 1)
  }
  r = matrix(mapply(function(r, s) {return (r/s)}, r, rowSums(r)), ncol=k)
  return (r)
}

# 10 persons but lettuce pre-cut one out of four times, etc
cats <- c( 1/4, 1/3, 1/2)
counts <- c( 10, 20, 40 )

# bootstrap sample
n<-10000

probs <- rdirichlet( n, counts )

# Just for checking: the mean of the columns should give the probabilities
colMeans( probs )
counts/sum( counts )

# we are interested in cats[1]*counts[1] + cats[2]*counts[2]
# or better: in the uncertainty of this
# This is conveniently done with matrix-vector multiplication
bootstrapsample <- probs %*% cats

# Just for checking
mean( bootstrapsample )
cats %*% counts/sum( counts )

# finally the 95% interval
quantile( bootstrapsample, probs=c(0.025,0.975))
