cat1 <- function( answers, answers.label, weights, savePDF=FALSE, saveExcel=FALSE ){   
  
  df <- data.frame( s=answers, w=1/weights )
  s  <- df %>% group_by( s ) %>% summarize( x=sum(w))
  s  <- as.numeric( s$x )
  n  <- sum( s )

  m <- nrow( answers.label )
  
  # Uncertainties
  df <- data.frame( phat = s / n,
                    low  = qbeta(0.025, shape1 = s+1, shape2=n - s - m -1 ),
                    high = qbeta(0.975, shape1 = s+1, shape2=n - s - m -1 ),
                    ymin = rep(0,m),
                    ymax = rep(1,m),
                    x =  answers.label$DESC               
  )
  
  if( saveExcel){
    p.unc <- matrix( data=rbeta(m*nMCsamples, shape1 = s+1, shape2=n - s - m -1 ),
                     nrow=nMCsamples, 
                     ncol=m,
                     byrow=TRUE )

    par <- data.frame( answer=answers.label$DESC, phat= s/n, a=s+1, b=n - s - m -1  )

    samples <- matrix( nrow = m*nMCsamples, ncol=nMCsamples )
    for( i in 1:nMCsamples ){
      mat <- rmultinom( nMCsamples, n, p.unc[i,] )
      samples[  (((i-1)*m+1):(i*m)), ]<- mat
    }
    rownames( samples ) <- paste( rep( 1:nMCsamples, each=m), rep( paste( "cat ", 1:m ), nMCsamples ))
    

    wb <- createWorkbook()
    
    addWorksheet(wb = wb, sheetName = "Param Samples")
    writeData(wb = wb, sheet = "Param Samples", x = p.unc, borders = "n", rowNames=T)
    addWorksheet(wb = wb, sheetName = "Parameters Uncertainty")
    writeData(wb = wb, sheet = "Parameters Uncertainty", x = par, borders = "n", rowNames=T)
    addWorksheet(wb = wb, sheetName = "Outcome Samples")
    writeData(wb = wb, sheet = "Outcome Samples", x = samples, borders = "n", rowNames=T)
    
    saveWorkbook(wb, paste("./Outcomes/",codes[j], ".xlsx", sep="" ), overwrite = TRUE)
  }
  
  if( savePDF ){
    # Plot statistics
    p <- ggplot( df, aes( x=x, lower=low, middle=phat, upper=high, ymin=low, ymax=high ) )
    p <- p + geom_boxplot(stat="identity" )
    p <- p + scale_y_continuous(labels = percent, breaks=seq(0,1,0.1))
    p <- p + labs( title=figure.label, x="Category", y="Population fraction" )
    p <- p + theme_bw()
    p <- p + theme(axis.text.x=element_text(angle = -90, hjust = 0))
    p <- p + theme(plot.title = element_text(size = rel(0.5)))
    p
    ggsave( paste(codes[j], "_stats.eps", sep=""), path="Figuren", colormodel="RGB",
            width=10, height=10, units="cm" )
  }
  return( df )
}