cat3 <- function( answers, answers.value, weights, label.answer, nMCsamples,
                  savePDF=FALSE, saveExcel=FALSE ){
  
  n         <- length( answers )
  mc.sample <- matrix( 0, nrow=nMCsamples, ncol=nMCsamples )
  ss.hat    <- matrix( 0, nrow=nMCsamples, ncol=2 )
  
  for( i in 1:nMCsamples )
  {
    # Count occurrences
    ind <-sample.int( n=n, replace=TRUE )
    data.counts <- data.frame( answers = answers[ind], w= 1/weights[ind] ) %>%
                    group_by(answers) %>% summarize( Freq=sum( w) ) 
    # Replace in the data, the answer strings with the numerical values
    data.counts <- merge( data.counts, answers.value, by.x="answers", by.y="ANSWER" )

    param <- c( log(10), log(10) )
    sol<-optim( par=param, fn=loglikgamma, f=data.counts )
    ss.hat[i,] <- exp( sol$par )
    
    mc.sample[i,] <- rgamma( nMCsamples, shape=ss.hat[i,1], scale=ss.hat[i,2] )
  }
  
  stats <- get.stats.2d( mc.sample )
  
  if( saveExcel){
    wb <- createWorkbook()
    
    addWorksheet(wb = wb, sheetName = "Param Samples")
    writeData(wb = wb, sheet = "Param Samples", x = ss.hat, borders = "n", rowNames=T)
    addWorksheet(wb = wb, sheetName = "Outcome Statistics")
    writeData(wb = wb, sheet = "Outcome Statistics", x = stats, borders = "n", rowNames=T)
    addWorksheet(wb = wb, sheetName ="Outcome Samples")
    writeData(wb = wb, sheet ="Outcome Samples", x = mc.sample, borders = "n", rowNames=T)
    
    saveWorkbook(wb, paste("./Outcomes/",codes[j], ".xlsx", sep="" ), overwrite = TRUE)

  }
  
  if( savePDF ){
    p <- ggplot(data.frame(x = c(0, 150)), aes(x))
    for( i in 1:nMCsamples )
    {
      p <- p + stat_function(fun = pgamma, geom = "line", #alpha=0.2,
                             args=list(shape=ss.hat[i,1], scale=ss.hat[i,2], lower.tail=FALSE ))
    }
    p <- p + labs( title = figure.label, x="More than [Time]", y="Population fraction" )
    p <- p + scale_y_continuous(labels = percent, breaks=seq(0,1,0.1))
    p <- p + scale_x_continuous( )
    p <- p + theme(plot.title = element_text(size = rel(0.5)))
    p + theme_bw()
    
    ggsave( paste(codes[j], "_stats.eps", sep="" ), path="Figuren", colormodel="RGB",
            width=10, height=10, units="cm" )
  }
  return(  list( stats=stats, ss.hat=colMeans( ss.hat) ) )
}