********************************
*Labeling Cost Model           *
*November 12, 2001             *
*Revised April 22, 2002        *
*Revised October 8, 2002       *
*RTI                           *
*Stata version 7.0             *
********************************

capture program drop labmodel
program define labmodel

set more off
set trace off
tempfile prod results comp pack anal stick mark all costs soda

***Product Choices********************************************
*Create a temporary product file based on User's choices.    *
*This temporary file will be used to build the results files.*
**************************************************************

use c:\Labels\product.dta, clear
preserve

  keep if $Product

/****SKUs, Units, and Formulas based on % of industry that can't coordinate change****/

  gen psku=sku*(1-$PChange)
  replace psku=sku*(1-$BChange) if pribrand=="B"

  gen punits=units*(1-$PChange)
  replace punits=units*(1-$BChange) if pribrand=="B"

  gen pformulas=formulas*(1-$PChange)
  replace pformulas=formulas*(1-$BChange) if pribrand=="B"

  drop sku units formulas

  sort printid
  save "`prod'", replace

***Print Costs (Color Change)***********************************
*Join temp product file with Print Table (join=printid)        *
*Keep records based on User's label change choices (# colors). *
*Start building the Results file.                              *
****************************************************************

use c:\Labels\print.dta, clear
  sort printid
  save c:\Labels\print.dta, replace

use "`prod'", clear
  joinby printid using c:\Labels\print.dta
  keep if $Color
  drop colors
  save "`results'", replace

***Inventory Costs (Compliance period)********************************************************
*Join temp product file with Package Table (join=repprod) to bring in costs.                 *
*Join above file with Inventory Table (join=packtype pribrand) to bring in compliance period.*
*Keep records based on user's compliance period choice.                                      *
*Calculate inventory costs using (packagecost times amtofinventory).                         *
*Save results as temp file, append onto results file.                                        *
**********************************************************************************************

use c:\Labels\package.dta, clear
  sort repprod prodsize
  save c:\Labels\package.dta, replace

/****Package table and costs****/

use "`prod'", clear
  sort repprod prodsize
  joinby repprod prodsize using c:\Labels\package.dta
  sort packtype pribrand
  drop costtype
  save "`comp'", replace

use c:\Labels\inventory.dta, clear
  sort packtype pribrand
  save c:\Labels\inventory.dta, replace

/****Inventory table, compliance period, and amt of inventory****/

use "`comp'", clear
  joinby packtype pribrand using c:\Labels\inventory.dta

  /****If Compliance=6 months use 12 months numbers else use User's choice****/

    if $Comp==6 {
      keep if compperd=="12 months"
    }
    else {
     keep if $Comply
    }

  drop compperd
  replace cost=cost*amtinv
  save "`pack'", replace

use "`results'", clear
  append using "`pack'"
  save "`results'", replace

  /****If Compliance=6 months bring in additional sticker costs            ****/
  /****Merge onto temp product file (join=costtype), append to results file****/

    if $Comp==6 {
      use c:\Labels\sticker.dta, clear
      qui collapse (sum) cost, by(costtype costlev)
      save "`stick'", replace

      use "`prod'", clear
      gen str10 costtype="sticker"
      joinby costtype using "`stick'"
      save "`stick'", replace

      use "`results'", clear
      append using "`stick'"
      save "`results'", replace
      }

***Analytical Costs******************************************************
*Get User's analytical choices.  Collapse (sum) the costs into one cost.*
*Add Additional Tests Costs (if applicable).                            *
*Merge onto temp product file (join=costtype).                          *
*Save results as temp file, append onto results table.                  *
*************************************************************************

/****Check if Analytical tests were chosen****/

if $TogAnal==1 {

  use c:\Labels\analytical.dta, clear
    keep if $Analyte
    qui collapse (sum) cost, by(costtype costlev)
    replace cost = cost + $AddTest
    save "`anal'", replace

  use "`prod'", clear
    gen str10 costtype="analytical"
    joinby costtype using "`anal'"
    save "`anal'", replace

  use "`results'", clear
    append using "`anal'"
    save "`results'", replace
   }

/****If No tests chosen but Additional Tests were added                 ****/
/****Collapse Analytical Table, replace costs with Additional Test Costs****/
/****Append onto results file                                           ****/

else if $TogAnal==0 & $AddTest>0 {

  use c:\Labels\analytical.dta, clear
    qui collapse (sum) cost, by(costtype costlev)
    replace cost = $AddTest
    save "`anal'", replace

  use "`prod'", clear
    gen str10 costtype="analytical"
    joinby costtype using "`anal'"
    save "`anal'", replace

  use "`results'", clear
    append using "`anal'"
    save "`results'", replace
  }

***Market Costs**********************************************************
*Get User's market choices.  Collapse (sum) the costs into one cost.    *
*Merge onto temp product file (join=costtype).                          *
*Save results as temp file, append onto results table.                  *
*************************************************************************

if $TogMark==1 {

  use c:\Labels\market.dta, clear
    keep if $Market
    qui collapse (sum) cost, by(costtype costlev)
    save "`mark'"

  use "`prod'", clear
    gen str10 costtype="market"
    joinby costtype using "`mark'"
    save "`mark'", replace

  use "`results'", clear
    append using "`mark'"
    save "`results'", replace
}

***Scaling Up All Costs using SKU or Units********
*Using results file                              *
*Calculations based on cost type                 *
*All costs multiplied by Price Adjustment factor *
**************************************************

/****Print and Admin Costs                              ****/
/****If compliance= 6 or 12 months then multiply by 1.1 ****/

  gen newcost=cost*psku*$Inflate*$Adj if costtype=="admin" | costtype=="engraving" | costtype=="graphic" | costtype=="prepress"

/****Analytical costs                                                         ****/
/****Two tests per product and additional shipping and handling costs (41.03) ****/

  replace newcost=((cost*2)+41.03)*(pformulas)*$Inflate if costtype=="analytical" & outin=="out"

/****Market, Inventory, Sticker Costs****/

  replace newcost=(cost*(pformulas)*$Inflate) if costtype=="market" & outin=="out"
  replace newcost=cost*punits*$Inflate if costtype=="inventory"
  replace newcost=cost*(punits/2)*$Inflate if costtype=="sticker" & outin=="out"

  drop cost
  rename newcost cost
  sort prodtype prodcat pribrand costtype costlev
  save "`results'", replace

***Costs by Cost Type************************************************************************
*Some products have 2 packages (in and out). Need to collapse to one.                       *
*Exception=Carbonated Beverages which has 3 packages                                        *
*Collapse costs by product type, product category, private/branded, cost type               *
*Join with temp product table (join=prodtype prodcat pribrand) to bring in descriptor fields*
*Save results as a permanent dataset then output as tab-delimited file                      *
*********************************************************************************************

use "`results'", clear
  collapse (sum) cost, by(prodtype prodcat pribrand costtype costlev)
  sort prodtype prodcat pribrand
  save"`costs'",replace

  if $Coke==1 {

    use "`prod'", clear
    keep if prodcat=="Carbonated Beverages-Regular" | prodcat=="Carbonated Beverages-Sugar Substitute"
    keep if outin=="out"
    sort prodcat pribrand
    collapse (sum) psku punits, by(prodcat pribrand)
    save "`soda'", replace

    use "`prod'", clear
    sort prodtype prodcat pribrand
    drop if outin=="in"
    drop if repprod=="Coca-Cola" & printid=="F"
    drop if repprod=="Diet Coke" & printid=="F"
    sort prodcat pribrand
    merge prodcat pribrand using "`soda'", update replace
    sort prodtype prodcat pribrand
    tabulate _merge
    drop _merge
   }

  else {
    use "`prod'", clear
    sort prodtype prodcat pribrand
    drop if outin=="in"
    }

  joinby prodtype prodcat pribrand using "`costs'"
  rename psku sku
  rename punits units
  rename pformulas formulas
  drop outin
  save c:\Labels\allcosts.dta, replace
  outsheet using c:\Labels\allcosts.out, replace

/***Create Aggregate Cost File***/

  use "C:\Labels\allcosts.dta", clear
  sort prodtype prodcat naiccode naicdes pribrand sku units formulas costlev
  collapse (sum) cost, by(prodtype prodcat naiccode naicdes pribrand sku units formulas costlev)

  reshape wide cost, i(prodtype prodcat pribrand) j(costlev) string

  save "C:\Labels\labelcostag.dta", replace
  outsheet using "C:\Labels\labelcostag.out", replace

end
