********************************
*Reformulation Model           *
*March 13, 2002                *
*Revised: June 23, 2002        *
*RTI                           *
*Stata version 7.0             *
********************************

capture program drop formulate
program define formulate

set more off
set trace off
tempfile prod resp results crprod anal sense consume comp finish raw

***Product Choices**********************************************
/*Shift through product choices one at a time.                */
/*Create a temporary product file based on User's choices.    */
/*This temporary file will be used to build the results files.*/

  use "C:\Reformulation\product.dta", clear
    preserve
    global pcount=1

    while `"`1'"' ~= "" {
      restore, preserve
      keep if prodcat== "`1'"

    /*Generate affected formulas, skus, dollars and units by  */
    /*1) % of industry that can coordinate change and         */
    /*2) % of product category affected.                      */

      replace formulas=(1-$Coord)*${Affect$pcount}*formulas
      replace skus=(1-$Coord)*${Affect$pcount}*skus
      replace dollars=(1-$Coord)*${Affect$pcount}*dollars
      replace units=(1-$Coord)*${Affect$pcount}*units

      recast int skus formulas, force

      save "`prod'", replace

***Response Costs************************************************
/*Keep records based on User's response and ingredient choices.*/
/*Save results as temp file                                    */

    use "C:\Reformulation\response.dta", clear
      keep if ${Response$pcount}
      keep if ${Ingredient$pcount}

      global Amult=1
      global Smult=2
      global Cmult=1

    /*Determine Test Multipliers                  */

      local mino : subinstr global Ingredient$pcount "minornc" "sub", all count(local n1)
      local maj : subinstr global Ingredient$pcount "major" "sub", all count(local n2)
      local pro : subinstr global Ingredient$pcount "process" "sub", all count(local n3)

      if `n1'>0 {
       global Smult=$Smult-1}
      else if `n2'>0 {
       global Amult=$Amult+1}
      else if `n3'>0 {
       global Amult=$Amult+1
       global Smult=$Smult+2
       global Cmult=$Cmult+1}

      save "`resp'", replace

    /*Merge onto temp product file.*/

      use "`prod'", clear
        cross using "`resp'"

    /*Scale up costs using                        */
    /*1) number of affected formulas and          */
    /*2) price adjustment factor.                 */

        replace cost=cost*formulas*$Inflate*$Adj
        drop response ingredlev

    /*Save results as temp file, append onto results table.*/

        if $pcount==1 {
          save "`results'", replace}
        else {
          save "`crprod'", replace
          use "`results'", clear
          append using "`crprod'"
          save "`results'", replace}

***Analytical Costs (Optional)***********************************
/*Check for empty string if no error then  */
/*Get User's analytical choices.           */
/*Collapse (sum) the costs into one cost.  */
/*Add User additional test costs           */
/*Save results as temp file                */

    use "C:\Reformulation\analytical.dta", clear
      capture local ifa=${Analysis$pcount}
      if _rc==0 {
        keep if ${Analysis$pcount}
        qui collapse (sum) cost, by(costtype costlev)
        replace cost=cost + ${Addtest$pcount}
        save "`anal'", replace

    /*Merge onto temp product file.*/

        use "`prod'", clear
          cross using "`anal'"

    /*Scale up costs same as Response Costs plus        */
    /*5) 2 tests per product,                           */
    /*6) multiplier based on ingredient level, and      */
    /*7) additional shipping and handling costs (41.03).*/

          replace cost=formulas*$Inflate*$Amult*((cost*2)+41.03)

    /*Save results as temp file, append onto results table.*/

          save "`anal'", replace
          use "`results'", clear
          append using "`anal'"
          save "`results'", replace}

***Sensory Costs (Optional)**************************************
/*Check for empty string if no error then  */
/*Get User's sensory test choices.         */
/*Collapse (sum) the costs into one cost.  */
/*Save results as temp file                */

    use "C:\Reformulation\sensory.dta", clear
      capture local ifs=${Sensory$pcount}
      if _rc==0 {
         keep if ${Sensory$pcount}
         qui collapse (sum) cost, by(costtype costlev)
         save "`sense'", replace

    /*Merge onto temp product file.*/

         use "`prod'", clear
           cross using "`sense'"

    /*Scale up costs same as Response Costs plus    */
    /*5) multiplier based on ingredient level.      */

           replace cost=cost*formulas*$Inflate*$Smult

    /*Save results as temp file, append onto results table.*/

           save "`sense'", replace
           use "`results'", clear
           append using "`sense'"
           save "`results'", replace}

***Consumer Costs (Optional)*************************************
/*Check for empty string if no error then  */
/*Get User's consumer test choices.        */
/*Collapse (sum) the costs into one cost.  */
/*Save results as temp file                */

    use "C:\Reformulation\consumer.dta", clear
      capture local ifc=${Consumer$pcount}
      if _rc==0 {
        keep if ${Consumer$pcount}
        qui collapse (sum) cost, by(costtype costlev)
        save "`consume'", replace

    /*Merge onto temp product file.*/

        use "`prod'", clear
          cross using "`consume'"

    /*Scale up costs same as Response Costs plus    */
    /*5) multiplier based on ingredient level.      */

          replace cost=cost*formulas*$Inflate*$Cmult

    /*Save results as temp file, append onto results table.*/

          save "`consume'", replace
          use "`results'", clear
          append using "`consume'"
          save "`results'", replace}

***Inventory Costs***********************************************
/*Keep records based on User's compliance period choice. */
/*Save results as temp file                              */

    use "C:\Reformulation\inventory.dta", clear
      keep if $Comply
      sort pribrand
      save "`comp'", replace

  /***Parse out Finished Materials***/

      keep if costtype=="finished"
      save "`finish'", replace

    /*Merge onto temp product file (join=pribrand).*/

      use "`prod'", clear
        sort pribrand
        joinby pribrand using "`finish'"

    /*Scale up costs using                              */
    /*1) % of inventory remaining,                      */
    /*2) ratio of wholesale to retail price (0.5), and  */
    /*3) affected retail sales of product category.     */

        gen cost=amtinv*0.5*dollars*$Inflate
        replace costtype="inventory"
        save "`finish'", replace

  /***Parse out Raw Materials***/

      use "`comp'", clear
        keep if costtype=="raw"
        save "`raw'", replace

    /*Merge onto temp product file (join=pribrand).*/

      use "`prod'", clear
        sort pribrand
        joinby pribrand using "`raw'"

    /*Scale up costs same as Finished except price ratios (#4) */
    /*4) ratio of raw materials costs to retail price (0.2).   */

        gen cost=amtinv*0.2*dollars*$Inflate
        replace costtype="inventory"
        save "`raw'", replace

  /***Combine Finished and Raw Materials Temp Files***/
        append using "`finish'"
        sort prodtype prodcat pribrand costtype
        save "`comp'", replace

    /*Collapse (sum) the costs into one cost.  */

      qui collapse (sum) cost, by(prodtype prodcat pribrand costtype)

    /*Create 3 cost levels using collapsed costs */

        expand 3
        sort prodtype prodcat pribrand costtype
        by prodtype prodcat pribrand costtype: gen long tcount=_n
        gen str4 costlev="low"
        replace costlev="med" if tcount==2
        replace costlev="high" if tcount==3
        sort prodtype prodcat pribrand

    /*Save results as temp file, Merge onto temp product file.*/

        save "`comp'", replace
        use "`prod'", clear
        sort prodtype prodcat pribrand
        joinby prodtype prodcat pribrand using "`comp'"
        drop tcount

    /*Save results as temp file, append onto results table.*/

        save "`comp'", replace
        use "`results'", clear
        append using "`comp'"
        save "`results'", replace

  /***Adjust product counter by 1***/
  /***Shift to Next Product Choice***/

     global pcount=$pcount + 1
     macro shift
   }
  format cost %20.0g
  sort prodtype prodcat pribrand costtype costlev
  save "C:\Reformulation\reformcost.dta", replace
  outsheet using "C:\Reformulation\reformcost.out", replace

  /***Create Aggregate Cost File***/

  use "C:\Reformulation\reformcost.dta", clear
  sort prodtype prodcat naiccode naicdes pribrand units dollars formulas skus costlev
  collapse (sum) cost, by(prodtype prodcat naiccode naicdes pribrand units dollars formulas skus costlev)

  reshape wide cost, i(prodtype prodcat pribrand) j(costlev) string

  save "C:\Reformulation\reformcostag.dta", replace
  outsheet using "C:\Reformulation\reformcostag.out", replace
end
